package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantUserService;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListAddRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserSelectPageResponse;
import com.yd.user.service.model.RelTenantUser;
import com.yd.user.service.service.IRelTenantUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiRelTenantUserServiceImpl implements ApiRelTenantUserService {

    @Autowired
    private IRelTenantUserService iRelTenantUserService;

    /**
     * 租户和用户关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantUserListPageResponse>> page(ApiRelTenantUserListPageRequest request) {
        Page<ApiRelTenantUserListPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantUserListPageResponse> iPage = iRelTenantUserService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加租户和用户列表关系
     * @param request
     * @return
     */
    @Override
    public Result addUserList(ApiRelTenantUserListAddRequest request) {
        List<RelTenantUser> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(request.getUserBizIdList())) {
            //用户唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getUserBizIdList().stream().map(bizId -> {
                RelTenantUser relTenantUser = new RelTenantUser();
                relTenantUser.setTenantBizId(request.getTenantBizId());
                relTenantUser.setUserBizId(bizId);
                return relTenantUser;
            }).collect(Collectors.toList());

            iRelTenantUserService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }

    /**
     * 删除租户和用户关系
     * @param id 租户和用户关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        RelTenantUser relTenantUser = iRelTenantUserService.queryOne(id);
        if (Objects.isNull(relTenantUser)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        iRelTenantUserService.removeById(relTenantUser.getId());
        return Result.success();
    }

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前租户用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantUserSelectPageResponse>> selectUserPage(ApiRelTenantUserSelectPageRequest request) {
        Page<ApiRelTenantUserSelectPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantUserSelectPageResponse> iPage = iRelTenantUserService.selectUserPage(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加单个租户和用户关系
     * @param tenantBizId
     * @param userBizId
     * @return
     */
    @Override
    public Result addSingleRel(String tenantBizId, String userBizId) {
        RelTenantUser relTenantUser = new RelTenantUser();
        relTenantUser.setTenantBizId(tenantBizId);
        relTenantUser.setUserBizId(userBizId);
        iRelTenantUserService.saveOrUpdate(relTenantUser);
        return Result.success();
    }
}
