package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectRoleService;
import com.yd.user.feign.client.relprojectrole.ApiRelProjectRoleFeignClient;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListAddRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListPageRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleSelectPageRequest;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleListPageResponse;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * 项目-角色关系信息（项目管理-角色配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relProjectRole")
@Validated
public class ApiRelProjectRoleController implements ApiRelProjectRoleFeignClient {

    @Autowired
    private ApiRelProjectRoleService apiRelProjectRoleService;

    /**
     * 项目和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectRoleListPageResponse>> page(ApiRelProjectRoleListPageRequest request) {
        return apiRelProjectRoleService.page(request);
    }

    /**
     * 添加项目和角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRoleList(ApiRelProjectRoleListAddRequest request) {
        return apiRelProjectRoleService.addRoleList(request);
    }

    /**
     * 删除项目和角色关系
     * @param id 项目和角色关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelProjectRoleService.del(id);
    }

    /**
     * 导入-选择角色分页查询（查询当前项目级（当前所属项目绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectRoleSelectPageResponse>> selectRolePage(ApiRelProjectRoleSelectPageRequest request) {
        return apiRelProjectRoleService.selectRolePage(request);
    }
}
