package com.yd.user.feign.fallback.relprojectrole;

import com.yd.common.result.Result;
import com.yd.user.feign.client.relprojectrole.ApiRelProjectRoleFeignClient;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListAddRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListPageRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleSelectPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务：项目-角色关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelProjectRoleFeignFallbackFactory implements FallbackFactory<ApiRelProjectRoleFeignClient> {
    @Override
    public ApiRelProjectRoleFeignClient create(Throwable cause) {
        return new ApiRelProjectRoleFeignClient() {
            @Override
            public Result page(ApiRelProjectRoleListPageRequest request) {
                return null;
            }

            @Override
            public Result addRoleList(ApiRelProjectRoleListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectRolePage(ApiRelProjectRoleSelectPageRequest request) {
                return null;
            }
        };
    }
}
