package com.yd.user.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.user.api.service.ApiClientUserService;
import com.yd.user.service.dto.ClientUserDto;
import com.yd.user.service.dto.SysUserDto;
import com.yd.user.service.model.ClientUser;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.service.IClientUserService;
import com.yd.user.service.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class ApiClientUserServiceImpl implements ApiClientUserService {

    @Autowired
    private ISysUserService iSysUserService;

    @Autowired
    private IClientUserService iClientUserService;

    /**
     * 同步sys_user系统用户，批量更新客户端用户表数据
     * @param userBizIdList
     * @param tenantBizId
     * @param projectBizId
     * @return
     */
    @Override
    public Result saveClientUserList(List<String> userBizIdList,
                                     String tenantBizId,
                                     String projectBizId) {
        List<SysUser> sysUserList = iSysUserService.queryList(SysUserDto.builder().userBizIdList(userBizIdList).build());
        if (!CollectionUtils.isEmpty(sysUserList)) {
            //根据用户唯一标识(sys_user系统用户表)列表查询客户端用户列表，来做更新。
            List<ClientUser> clientUserList = iClientUserService.queryList(ClientUserDto.builder()
                    .tenantBizId(tenantBizId)
                    .projectBizId(projectBizId)
                    .userBizIdList(userBizIdList)
                    .build());
            List<ClientUser> saveList = new ArrayList<>();
            if (CollectionUtils.isEmpty(clientUserList)) {
                //全部新增同步sys_user数据
                saveList = buildClientUserList(sysUserList,tenantBizId,projectBizId);
            }else {
                //部分新增部分更新
                //过滤出不在clientUserList中的sysUser
                Set<String> existUserBizIds = clientUserList.stream()
                        .map(ClientUser::getUserBizId)
                        .collect(Collectors.toSet());
                List<SysUser> newSysUsers = sysUserList.stream()
                        .filter(sysUser -> !existUserBizIds.contains(sysUser.getUserBizId()))
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(newSysUsers)) {
                    //新增同步sys_user数据
                    saveList = buildClientUserList(sysUserList,tenantBizId,projectBizId);
                }
            }

            if (!CollectionUtils.isEmpty(saveList)) {
                iClientUserService.saveOrUpdateBatch(saveList);
            }
        }
        return Result.success();
    }

    /**
     * 根据List<SysUser>构造List<ClientUser>
     * @param sysUserList
     * @return
     */
    public List<ClientUser> buildClientUserList(List<SysUser> sysUserList,
                                                String tenantBizId,
                                                String projectBizId) {
        List<ClientUser> clientUserList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(sysUserList)) {
            clientUserList = sysUserList.stream().map(dto -> {
                ClientUser clientUser = new ClientUser();
                //待审核
                clientUser.setApprovalStatus(CommonEnum.APPROVAL_STATUS_DSH.getCode());
                clientUser.setClientUserBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_CLIENT_USER.getCode()));
                clientUser.setEmail(dto.getEmail());
                //邀请码 TODO
//                clientUser.setInvitationCode();
                clientUser.setName(dto.getRealName());
                clientUser.setPhone(dto.getMobile());
                clientUser.setTenantBizId(tenantBizId);
                clientUser.setProjectBizId(projectBizId);
                //用户唯一标识(sys_user系统用户表)
                clientUser.setUserBizId(dto.getUserBizId());
                return clientUser;
            }).collect(Collectors.toList());
        }
        return clientUserList;
    }

}
