package com.yd.user.feign.client.sysmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysmenu.ApiSysMenuFeignFallbackFactory;
import com.yd.user.feign.request.sysmenu.ApiSysMenuAddRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuEditRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuTreeListRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuDetailResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务：菜单信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysMenuFeignFallbackFactory.class)
public interface ApiSysMenuFeignClient {

    /**
     * 树形菜单列表查询
     * @param request
     * @return
     */
    @PostMapping("/tree/list")
    Result<List<ApiSysMenuTreeListResponse>> treeList(@RequestBody ApiSysMenuTreeListRequest request);

    /**
     * 菜单分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysMenuPageRequest request);

    /**
     * 获取菜单详情
     * @param menuBizId 菜单唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysMenuDetailResponse> detail(@NotBlank(message = "菜单唯一标识(业务ID)不能为空") @RequestParam(value = "menuBizId") String menuBizId);

    /**
     * 添加菜单
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysMenuAddRequest request);

    /**
     * 编辑菜单
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSysMenuEditRequest request);


    /**
     * 删除菜单（逻辑删除）
     * @param menuBizId 菜单唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "菜单唯一标识(业务ID)不能为空") @RequestParam(value = "menuBizId") String menuBizId);

    /**
     * 编辑菜单状态
     * @param menuBizId 菜单唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "菜单唯一标识(业务ID)不能为空") @RequestParam(value = "menuBizId") String menuBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
