package com.yd.user.feign.response.systenant;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 获取租户详情-出参
 */
@Data
public class ApiSysTenantDetailResponse {

    /**
     * 租户ID
     */
    private Long id;

    /**
     * 租户唯一标识(业务ID)
     */
    private String tenantBizId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 租户编码(用于API标识)
     */
    private String tenantCode;

    /**
     * 租户LOGO
     */
    private String logoUrl;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 联系邮箱
     */
    private String contactEmail;

    /**
     * 所属行业
     */
    private String industry;

    /**
     * 联系地址
     */
    private String address;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 是否系统内置租户(0:否 1:是)
     */
    private Integer isSystem;

    /**
     * 服务到期时间
     */
    private LocalDateTime expireTime;

    /**
     * 最大项目数
     */
    private Integer maxProject;

    /**
     * 最大用户数
     */
    private Integer maxUser;

    /**
     * 最大存储空间(字节)
     */
    private Long maxStorage;

    /**
     * 租户级配置(JSON格式)
     */
    private String configJson;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
