package com.yd.user.feign.response.sysmenu;

import lombok.Data;

import java.util.List;

/**
 * 树形菜单列表查询
 */
@Data
public class ApiSysMenuTreeListResponse {

    /**
     * 菜单表主键id
     */
    private Long id;

    /**
     * 菜单唯一标识(业务ID)
     */
    private String menuBizId;

    /**
     * 父菜单ID
     */
    private String parentBizId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 类型(1:目录 2:菜单 3:按钮)
     */
    private Integer menuType;

    /**
     * 路由地址
     */
    private String path;

    /**
     * 组件路径
     */
    private String component;

    /**
     * 图标
     */
    private String icon;

    /**
     * 是否外链(0:否 1:是)
     */
    private Integer isExternal;

    /**
     * 是否缓存(0:否 1:是)
     */
    private Integer isCache;

    /**
     * 是否显示(0:隐藏 1:显示)
     */
    private Integer isVisible;

    /**
     * 菜单编码
     */
    private String menuCode;

    /**
     * 菜单权限标识(如:user:add)
     */
    private String permission;

    /**
     * 显示顺序
     */
    private Integer orderNum;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属租户名称
     */
    private String tenantName;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 子级菜单
     */
    private List<ApiSysMenuTreeListResponse> children;
}
