package com.yd.user.feign.fallback.reltenantuser;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reltenantuser.ApiRelTenantUserFeignClient;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListAddRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务：租户-用户关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantUserFeignFallbackFactory implements FallbackFactory<ApiRelTenantUserFeignClient> {
    @Override
    public ApiRelTenantUserFeignClient create(Throwable cause) {
        return new ApiRelTenantUserFeignClient() {
            @Override
            public Result page(ApiRelTenantUserListPageRequest request) {
                return null;
            }

            @Override
            public Result addUserList(ApiRelTenantUserListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectUserPage(ApiRelTenantUserSelectPageRequest request) {
                return null;
            }
        };
    }
}
