package com.yd.user.feign.fallback.clientuser;

import com.yd.common.result.Result;
import com.yd.user.feign.client.clientuser.ApiClientUserFeignClient;
import com.yd.user.feign.request.clientuser.ApiClientUserDetailBodyRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserEditApprovalStatusRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserSaveRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserDetailResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserSaveResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 客户端用户信息Feign降级处理
 */
@Slf4j
@Component
public class ApiClientUserFeignFallbackFactory implements FallbackFactory<ApiClientUserFeignClient> {
    @Override
    public ApiClientUserFeignClient create(Throwable cause) {
        return new ApiClientUserFeignClient() {
            @Override
            public Result page(ApiClientUserPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiClientUserDetailResponse> detail(String clientUserBizId) {
                return null;
            }

            @Override
            public Result<List<String>> clientUserBizIdList(String tenantBizId, String projectBizId) {
                return null;
            }

            @Override
            public Result<ApiClientUserDetailResponse> detail(ApiClientUserDetailBodyRequest request) {
                return null;
            }

            @Override
            public Result<ApiClientUserSaveResponse> save(ApiClientUserSaveRequest request) {
                return null;
            }

            @Override
            public Result editApprovalStatus(ApiClientUserEditApprovalStatusRequest request) {
                return null;
            }

            @Override
            public Result editOpenId(String clientUserBizId,String openId) {
                return null;
            }
        };
    }
}
