package com.yd.user.feign.client.reluserrole;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reluserrole.ApiRelUserRoleFeignFallbackFactory;
import com.yd.user.feign.request.reluserrole.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 用户服务：用户-角色关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelUserRoleFeignFallbackFactory.class)
public interface ApiRelUserRoleFeignClient {

    /**
     * 租户管理-用户配置-分配角色-添加用户角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/tenant/userRoleList")
    Result addTenantUserRoleList(@Validated @RequestBody ApiTenantUserRoleListAddRequest request);

    /**
     * 租户管理-用户配置-分配角色-移除用户角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/del/tenant/userRoleList")
    Result delTenantUserRoleList(@Validated @RequestBody ApiTenantUserRoleListDelRequest request);

    /**
     * 租户管理-用户配置-分配角色-查询待选的角色分页列表
     * @return
     */
    @PostMapping("/candidate/tenant/userRolePage")
    Result candidateTenantUserRolePage(@Validated @RequestBody ApiCandidateTenantUserRolePageRequest request);

    /**
     * 租户管理-用户配置-分配角色-查询选中的角色分页列表
     * @return
     */
    @PostMapping("/selected/tenant/userRolePage")
    Result selectedTenantUserRolePage(@Validated @RequestBody ApiSelectedTenantUserRolePageRequest request);

    /**
     * 项目管理-用户配置-分配角色-添加用户角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/project/userRoleList")
    Result addProjectUserRoleList(@Validated @RequestBody ApiProjectUserRoleListAddRequest request);

    /**
     * 项目管理-用户配置-分配角色-移除用户角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/del/project/userRoleList")
    Result delProjectUserRoleList(@Validated @RequestBody ApiProjectUserRoleListDelRequest request);

    /**
     * 项目管理-用户配置-分配角色-查询待选的角色分页列表
     * @return
     */
    @PostMapping("/candidate/project/userRolePage")
    Result candidateProjectUserRolePage(@Validated @RequestBody ApiCandidateProjectUserRolePageRequest request);

    /**
     * 项目管理-用户配置-分配角色-查询选中的角色列表
     * @return
     */
    @PostMapping("/selected/project/userRolePage")
    Result selectedProjectUserRolePage(@Validated @RequestBody ApiSelectedProjectUserRolePageRequest request);
}
