package com.yd.user.feign.client.relprojectmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.projectmenu.ApiRelProjectMenuFeignFallbackFactory;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListAddRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListPageRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuTreeListRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuTreeListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务：项目-菜单关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelProjectMenuFeignFallbackFactory.class)
public interface ApiRelProjectMenuFeignClient {

    /**
     * 项目和菜单关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelProjectMenuListPageRequest request);

    /**
     * 项目和菜单关系树形列表查询
     * @param request
     * @return
     */
    @PostMapping("/tree")
    Result<List<ApiRelProjectMenuTreeListResponse>> tree(@Validated @RequestBody ApiRelProjectMenuTreeListRequest request);

    /**
     * 添加项目和菜单列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/menu/list")
    Result addMenuList(@Validated @RequestBody ApiRelProjectMenuListAddRequest request);

    /**
     * 删除项目和菜单关系
     * @param id 项目和菜单关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "项目和菜单关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-树形菜单查询
     * @param request
     * @return
     */
    @PostMapping("/import/query/menu/tree")
    Result<List<ApiRelProjectMenuImportQueryMenuTreeResponse>> importQueryMenuTree(@Validated @RequestBody ApiRelProjectMenuImportQueryMenuTreeRequest request);

    /**
     * 导入-树形菜单-查询选中的菜单id集合
     * @param projectBizId
     * @return
     */
    @GetMapping("/import/query/selected/menu/list")
    Result<List<String>> selectedList(
            @NotBlank(message = "租户唯一标识(业务ID)不能为空") @RequestParam(value = "tenantBizId") String tenantBizId,
            @NotBlank(message = "项目id不能为空") @RequestParam(value = "projectBizId") String projectBizId);
}
