package com.yd.user.feign.client.mdcountry;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.mdcountry.ApiMdCountryFeignFallbackFactory;
import com.yd.user.feign.response.mdcountry.ApiMdCountryGroupResponse;
import com.yd.user.feign.response.mdcountry.ApiMdCountrySearchResponse;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "yd-user-api", fallbackFactory = ApiMdCountryFeignFallbackFactory.class)
public interface ApiMdCountryFeignClient {

    /**
     * 查询所有国家地区
     * @return
     */
    @GetMapping("/group")
    @Operation(summary = "查询所有国家地区")
    Result<ApiMdCountryGroupResponse> group();

    /**
     * 根据国家名称或国家代码查询国家地区
     * @param name
     * @return
     */
    @GetMapping("/search")
    @Operation(summary = "根据国家编码查询国家地区")
    Result<ApiMdCountrySearchResponse> search(@RequestParam("name") String name);
}
