package com.yd.user.feign.client.clientuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.clientuser.ApiClientUserFeignFallbackFactory;
import com.yd.user.feign.request.clientuser.ApiClientUserDetailBodyRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserEditApprovalStatusRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserSaveRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserDetailResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserSaveResponse;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 客户端用户信息Feign客户端
 */
@FeignClient(name = "yd-user-api",path = "/user/api/clientUser",fallbackFactory = ApiClientUserFeignFallbackFactory.class)
public interface ApiClientUserFeignClient {

    /**
     * 分页查询-客户端用户信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    @Operation(summary = "分页查询-客户端用户信息")
    Result page(@Validated @RequestBody ApiClientUserPageRequest request);

    /**
     * 详情-客户端用户信息
     * @param clientUserBizId
     * @return
     */
    @GetMapping("/detail")
    @Operation(summary = "详情-客户端用户信息")
    Result<ApiClientUserDetailResponse> detail(@NotBlank(message = "客户端用户表唯一业务ID不能为空") @RequestParam(value = "clientUserBizId") String clientUserBizId);


    /**
     * 根据条件查询客户端用户业务ID列表
     * @param tenantBizId
     * @param tenantBizId
     * @return
     */
    @GetMapping("/clientUserBizIdList")
    Result<List<String>> clientUserBizIdList(@RequestParam(value = "tenantBizId") String tenantBizId,
                                             @RequestParam(value = "projectBizId") String projectBizId);

    /**
     * 查询-客户端用户详情 body入参
     * @return
     */
    @PostMapping("/body/detail")
    Result<ApiClientUserDetailResponse> detail(@Validated @RequestBody ApiClientUserDetailBodyRequest request);

    /**
     * 保存-客户端用户信息（新增或者编辑）
     * @return
     */
    @PostMapping("/save")
    Result<ApiClientUserSaveResponse> save(@Validated @RequestBody ApiClientUserSaveRequest request);

    /**
     * 编辑-客户端用户审批状态
     * @return
     */
    @PutMapping("/edit/approvalStatus")
    Result editApprovalStatus(@Validated @RequestBody ApiClientUserEditApprovalStatusRequest request);

    /**
     * 编辑-客户端用户openId
     * @return
     */
    @PutMapping("/edit/openId")
    Result editOpenId(@NotBlank(message = "客户端用户表唯一业务ID不能为空") @RequestParam(value = "clientUserBizId") String clientUserBizId,
                      @NotBlank(message = "openId不能为空") @RequestParam(value = "openId") String openId);
}
