package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiUserSignExpandService;
import com.yd.user.feign.client.usersignexpand.ApiUserSignExpandFeignClient;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandAddRequest;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandEditRequest;
import com.yd.user.feign.request.usersignexpand.ApiUserSignExpandPageRequest;
import com.yd.user.feign.response.usersignexpand.ApiUserSignExpandDetailResponse;
import com.yd.user.feign.response.usersignexpand.ApiUserSignExpandPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统用户-签单用户扩展信息
 *
 * @author zxm
 * @since 2025-12-19
 */
@RestController
@RequestMapping("/userSignExpand")
@Validated
public class ApiUserSignExpandController implements ApiUserSignExpandFeignClient {

    @Autowired
    private ApiUserSignExpandService apiUserSignExpandService;

    /**
     * 签单员分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiUserSignExpandPageResponse>> page(ApiUserSignExpandPageRequest request) {
        return apiUserSignExpandService.page(request);
    }

    /**
     * 获取签单员详情
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiUserSignExpandDetailResponse> detail(String userSignBizId) {
        return apiUserSignExpandService.detail(userSignBizId);
    }

    /**
     * 添加签单员
     * @param request
     * @return
     */
    @Override
    public Result add(ApiUserSignExpandAddRequest request) {
        return apiUserSignExpandService.add(request);
    }

    /**
     * 编辑签单员
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiUserSignExpandEditRequest request) {
        return apiUserSignExpandService.edit(request);
    }

    /**
     * 删除签单员（逻辑删除） TODO
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String userSignBizId) {
        return apiUserSignExpandService.del(userSignBizId);
    }

    /**
     * 编辑签单员状态
     * @param userSignBizId 签单员唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String userSignBizId, Integer status) {
        return apiUserSignExpandService.editStatus(userSignBizId,status);
    }
}
