package com.yd.user.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 租户信息表
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Getter
@Setter
@ToString
@TableName("sys_tenant")
public class SysTenant implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 租户ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 租户唯一标识(业务ID)
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 租户名称
     */
    @TableField("tenant_name")
    private String tenantName;

    /**
     * 租户编码(用于API标识)
     */
    @TableField("tenant_code")
    private String tenantCode;

    /**
     * 租户LOGO
     */
    @TableField("logo_url")
    private String logoUrl;

    /**
     * 联系人姓名
     */
    @TableField("contact_name")
    private String contactName;

    /**
     * 联系电话
     */
    @TableField("contact_phone")
    private String contactPhone;

    /**
     * 联系邮箱
     */
    @TableField("contact_email")
    private String contactEmail;

    /**
     * 所属行业
     */
    @TableField("industry")
    private String industry;

    /**
     * 联系地址
     */
    @TableField("address")
    private String address;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 是否系统内置租户(0:否 1:是)
     */
    @TableField("is_system")
    private Integer isSystem;

    /**
     * 服务到期时间
     */
    @TableField("expire_time")
    private LocalDateTime expireTime;

    /**
     * 最大项目数
     */
    @TableField("max_project")
    private Integer maxProject;

    /**
     * 最大用户数
     */
    @TableField("max_user")
    private Integer maxUser;

    /**
     * 最大存储空间(字节)
     */
    @TableField("max_storage")
    private Long maxStorage;

    /**
     * 租户级配置(JSON格式)
     */
    @TableField("config_json")
    private String configJson;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
