package com.yd.user.feign.response.sysmenu;

import lombok.Data;
import java.time.LocalDateTime;

/**
 * 获取菜单详情出参
 */
@Data
public class ApiSysMenuDetailResponse {

    /**
     * 菜单主键id
     */
    private Long id;

    /**
     * 菜单唯一标识(业务ID)
     */
    private String menuBizId;

    /**
     * 父ID（树绑定的父id, 展示作用）
     */
    private String parentId;

    /**
     * 父菜单ID
     */
    private String parentBizId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 类型(1:目录 2:菜单 3:按钮)
     */
    private Integer menuType;

    /**
     * 路由名称
     */
    private String routeName;

    /**
     * 路由地址
     */
    private String path;

    /**
     * 路由参数
     */
    private String query;

    /**
     * 组件路径
     */
    private String component;

    /**
     * 图标
     */
    private String icon;

    /**
     * 是否外链(0:否 1:是)
     */
    private Integer isExternal;

    /**
     * 是否缓存(0:否 1:是)
     */
    private Integer isCache;

    /**
     * 是否显示(0:隐藏 1:显示)
     */
    private Integer isVisible;

    /**
     * 菜单编码
     */
    private String menuCode;

    /**
     * 菜单权限标识(如:user:add)
     */
    private String permission;

    /**
     * 显示顺序
     */
    private Integer orderNum;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属租户名称
     */
    private String tenantName;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 所属项目名称
     */
    private String projectName;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
