package com.yd.user.feign.client.sysuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysuser.ApiSysUserFeignFallbackFactory;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.request.sysuser.*;
import com.yd.user.feign.response.login.ApiLoginMenuInfoResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import com.yd.user.feign.response.login.GetLoginInfoResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务-系统用户信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysUserFeignFallbackFactory.class)
public interface ApiSysUserFeignClient {

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysUserPageRequest request);

    /**
     * 添加用户
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysUserAddRequest request);

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSysUserEditRequest request);

    /**
     * 获取用户详情
     * @param userBizId 用户业务唯一标识id
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysUserDetailResponse> detail(@NotBlank(message = "用户业务唯一标识id不能为空") @RequestParam(value = "userBizId") String userBizId);

    /**
     * 编辑用户状态
     * @param userBizId
     * @param status
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "用户唯一标识(业务ID)不能为空") @RequestParam(value = "userBizId") String userBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

    /**
     * 编辑用户密码
     * @return
     */
    @PutMapping("/edit/pwd")
    Result editPwd(@Validated @RequestBody ApiSysUserEditPwdRequest request);

    /**
     * 权限-管理端-获取用户登录后权限信息
     * @return
     */
    @GetMapping("/login/permission/getInfo")
    Result<GetLoginInfoResponse> getLoginInfo();

    /**
     * 权限-管理端-获取当前登录用户绑定的当前租户用户角色菜单列表
     * @return
     */
    @GetMapping("/login/permission/getMenuRouters")
    Result<List<ApiLoginMenuInfoResponse>> getMenuRouters(@NotBlank(message = "租户业务id不能为空") @RequestParam(value = "tenantBizId") String tenantBizId);

    /**
     * 权限-管理端-根据作用域分页查询租户或项目列表
     * @param request
     * @return
     */
    @PostMapping("/scope/page")
    Result scopePage(@Validated @RequestBody ApiScopePageRequest request);
}
