package com.yd.user.feign.client.sysuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysuser.ApiSysUserFeignFallbackFactory;
import com.yd.user.feign.request.sysuser.ApiSysUserAddRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户服务-系统用户信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysUserFeignFallbackFactory.class)
public interface ApiSysUserFeignClient {

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysUserPageRequest request);

    /**
     * 添加用户
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@RequestBody ApiSysUserAddRequest request);

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @PostMapping("/edit")
    Result edit(@RequestBody ApiSysUserEditRequest request);

    /**
     * 获取用户详情
     * @param userUid 用户业务唯一标识id
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysUserDetailResponse> detail(@RequestParam(value = "userUid") String userUid);
}
