package com.yd.user.api.service.impl;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectRoleService;
import com.yd.user.service.model.RelProjectRole;
import com.yd.user.service.service.IRelProjectRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiRelProjectRoleImpl implements ApiRelProjectRoleService {

    @Autowired
    private IRelProjectRoleService iRelProjectRoleService;

    /**
     * 添加单个关系
     * @param projectBizId
     * @param roleBizId
     * @return
     */
    @Override
    public Result addSingleRel(String projectBizId, String roleBizId) {
        RelProjectRole relProjectRole = new RelProjectRole();
        relProjectRole.setProjectBizId(projectBizId);
        relProjectRole.setRoleBizId(roleBizId);
        iRelProjectRoleService.saveOrUpdate(relProjectRole);
        return Result.success();
    }

}
