package com.yd.user.feign.client.clientuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.clientuser.ApiClientUserFeignFallbackFactory;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserDetailResponse;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotBlank;

/**
 * 客户端用户信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiClientUserFeignFallbackFactory.class)
public interface ApiClientUserFeignClient {

    /**
     * 分页查询-客户端用户信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    @Operation(summary = "分页查询-客户端用户信息")
    Result page(@Validated @RequestBody ApiClientUserPageRequest request);

    /**
     * 详情-客户端用户信息
     * @param clientUserBizId
     * @return
     */
    @GetMapping("/detail")
    @Operation(summary = "详情-客户端用户信息")
    Result<ApiClientUserDetailResponse> detail(@NotBlank(message = "客户端用户表唯一业务ID不能为空") @RequestParam(value = "clientUserBizId") String clientUserBizId);
}
