package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import com.yd.user.service.dto.SysMenuDto;
import com.yd.user.service.model.SysMenu;
import com.yd.user.service.dao.SysMenuMapper;
import com.yd.user.service.model.SysRole;
import com.yd.user.service.service.ISysMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 菜单权限表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class SysMenuServiceImpl extends ServiceImpl<SysMenuMapper, SysMenu> implements ISysMenuService {

    /**
     * 查询单个对象
     * @param menuBizId
     * @return
     */
    @Override
    public SysMenu queryOne(String menuBizId) {
        return this.getOne(new LambdaQueryWrapper<SysMenu>().eq(SysMenu::getMenuBizId,menuBizId));
    }

    /**
     * 根据条件查询菜单列表
     * @param dto
     * @return
     */
    @Override
    public List<SysMenu> queryList(SysMenuDto dto) {
        List<SysMenu> list = baseMapper.selectList(new LambdaQueryWrapper<SysMenu>()
                .eq(!Objects.isNull(dto.getId()),SysMenu::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getMenuBizId()) && !dto.getIsExcludeMy(),SysMenu::getMenuBizId,dto.getMenuBizId())
                .eq(StringUtils.isNotBlank(dto.getMenuName()),SysMenu::getMenuName,dto.getMenuName())
                .eq(!Objects.isNull(dto.getMenuType()),SysMenu::getMenuType,dto.getMenuType())
                .in(!CollectionUtils.isEmpty(dto.getMenuBizIdList()),SysMenu::getMenuBizId,dto.getMenuBizIdList())
                .ne(dto.getIsExcludeMy(),SysMenu::getMenuBizId,dto.getMenuBizId())
        );
        return list;
    }

    /**
     * 查询所有
     * @return
     */
    @Override
    public List<SysMenu> queryAll() {
        return this.list();
    }

    /**
     * 条件搜索构建菜单树的数据
     * @param loginTenantBizId
     * @param isAdmin
     * @param menuName
     * @param projectBizIdList
     * @return
     */
    @Override
    public List<ApiSysMenuTreeListResponse> treeList(String loginTenantBizId,
                                                     Boolean isAdmin,
                                                     String menuName,
                                                     List<String> projectBizIdList) {
        return baseMapper.treeList(loginTenantBizId,isAdmin,menuName,projectBizIdList);
    }

    /**
     * 菜单分页查询
     * @param page
     * @param request
     * @param isAdmin
     * @param projectBizIdList
     * @param loginTenantBizId
     * @return
     */
    @Override
    public IPage<ApiSysMenuPageResponse> page(Page<ApiSysMenuPageResponse> page,
                                              ApiSysMenuPageRequest request,
                                              Boolean isAdmin,
                                              List<String> projectBizIdList,
                                              String loginTenantBizId) {
        return baseMapper.page(page,request,isAdmin,projectBizIdList,loginTenantBizId);
    }

}
