package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserSelectPageResponse;
import com.yd.user.service.dto.RelTenantUserDto;
import com.yd.user.service.model.RelTenantProject;
import com.yd.user.service.model.RelTenantUser;
import com.yd.user.service.dao.RelTenantUserMapper;
import com.yd.user.service.service.IRelTenantUserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 租户-用户关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelTenantUserServiceImpl extends ServiceImpl<RelTenantUserMapper, RelTenantUser> implements IRelTenantUserService {

    /**
     * 租户和用户关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantUserListPageResponse> page(Page<ApiRelTenantUserListPageResponse> page,
                                                        ApiRelTenantUserListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前租户用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantUserSelectPageResponse> selectUserPage(Page<ApiRelTenantUserSelectPageResponse> page,
                                                                    ApiRelTenantUserSelectPageRequest request) {
        return baseMapper.selectUserPage(page,request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantUser queryOne(Long id) {
        return this.getById(id);
    }

    /**
     * 根据条件查询租户用户关系列表信息
     * @param dto
     * @return
     */
    @Override
    public List<RelTenantUser> queryList(RelTenantUserDto dto) {
        List<RelTenantUser> list = baseMapper.selectList(new LambdaQueryWrapper<RelTenantUser>()
                .eq(!Objects.isNull(dto.getId()),RelTenantUser::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),RelTenantUser::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getUserBizId()),RelTenantUser::getUserBizId,dto.getUserBizId())
        );
        return list;
    }
}
