package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysdept.ApiSysDeptCompanyPageRequest;
import com.yd.user.feign.request.sysdept.ApiSysDeptPageRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.response.sysdept.ApiSysDeptCompanyPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptTreeListResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import com.yd.user.service.dto.SysDeptDto;
import com.yd.user.service.dto.SysMenuDto;
import com.yd.user.service.model.SysDept;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.user.service.model.SysMenu;

import java.util.List;

/**
 * <p>
 * 部门表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface ISysDeptService extends IService<SysDept> {

    List<ApiSysDeptTreeListResponse> treeList(String loginTenantBizId,
                                              Boolean isAdmin,
                                              String deptName,
                                              List<String> projectBizIdList);

    IPage<ApiSysDeptPageResponse> page(Page<ApiSysDeptPageResponse> page,
                                       ApiSysDeptPageRequest request,
                                       Boolean isAdmin,
                                       List<String> projectBizIdList,
                                       String loginTenantBizId);

    IPage<ApiSysDeptCompanyPageResponse> companyPage(Page<ApiSysDeptCompanyPageResponse> page,
                                                     ApiSysDeptCompanyPageRequest request);

    SysDept queryOne(String deptBizId);

    List<SysDept> queryList(SysDeptDto dto);
}
