package com.yd.user.service.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RelUserRoleDto {

    private Long id;

    /**
     * 关系类型（0-租户关系 1-项目关系）
     */
    private Integer type;

    /**
     * 租户ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：租户级)
     */
    private String tenantBizId;

    /**
     * 项目ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：项目级)
     */
    private String projectBizId;

    /**
     * 用户ID（业务id）
     */
    private String userBizId;

    /**
     * 角色ID（业务id）
     */
    private String roleBizId;
}
