package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysdept.ApiSysDeptCompanyPageRequest;
import com.yd.user.feign.request.sysdept.ApiSysDeptPageRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.response.sysdept.ApiSysDeptCompanyPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptTreeListResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import com.yd.user.service.model.SysDept;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 部门表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface SysDeptMapper extends BaseMapper<SysDept> {

    List<ApiSysDeptTreeListResponse> treeList(@Param("loginTenantBizId") String loginTenantBizId,
                                              @Param("isAdmin") Boolean isAdmin,
                                              @Param("deptName") String deptName,
                                              @Param("projectBizIdList") List<String> projectBizIdList);

    IPage<ApiSysDeptPageResponse> page(@Param("page") Page<ApiSysDeptPageResponse> page,
                                       @Param("request") ApiSysDeptPageRequest request,
                                       @Param("isAdmin") Boolean isAdmin,
                                       @Param("projectBizIdList") List<String> projectBizIdList,
                                       @Param("loginTenantBizId") String loginTenantBizId);

    IPage<ApiSysDeptCompanyPageResponse> companyPage(@Param("page") Page<ApiSysDeptCompanyPageResponse> page,
                                                     @Param("request") ApiSysDeptCompanyPageRequest request);
}
