package com.yd.user.feign.response.sysproject;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 项目分页查询出参
 */
@Data
public class ApiSysProjectPageResponse {

    /**
     * 项目ID
     */
    private Long id;

    /**
     * 项目唯一标识(业务ID)
     */
    private String projectBizId;

    /**
     * 项目图标地址
     */
    private String logoUrl;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 项目开始时间
     */
    private LocalDateTime startTime;

    /**
     * 项目结束时间
     */
    private LocalDateTime endTime;

    /**
     * 作用域(1:系统级（全局） 2:租户级 )
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属租户名称
     */
    private String tenantName;

    /**
     * 是否内置项目（0-否 1-是 默认0-否 是内置项目，那么整个项目的所绑定的菜单权限都在中台系统展示内嵌外链iframe, 如果不是直接是访问项目卡片直接跳转到独立的前端项目链接获取权限菜单访问）
     */
    private Integer isIn;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 项目类型（PC、客户端）
     */
    private String projectType;
}
