package com.yd.user.feign.response.reluserrole;

import lombok.Data;

@Data
public class ApiSelectedTenantUserRolePageResponse {

    /**
     * 用户角色关系表主键id
     */
    private Long id;

    /**
     * 租户ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：租户级)
     */
    private String tenantBizId;

    /**
     * 项目ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：项目级)
     */
    private String projectBizId;

    /**
     * 用户ID（业务id）
     */
    private String userBizId;

    /**
     * 角色唯一标识(业务ID)
     */
    private String roleBizId;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 角色类型(1:超级管理员 2:管理员 3:普通用户)
     */
    private Integer roleType;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;
}
