package com.yd.user.feign.response.relprojectmenu;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目和菜单关系分页查询出参
 */
@Data
public class ApiRelProjectMenuListPageResponse {

    /**
     * 项目和菜单关系主键id
     */
    private Long id;

    /**
     * 项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 菜单表主键id
     */
    private Long menuId;

    /**
     * 菜单ID（业务id）（用于前端显示绑定参数）
     */
    private String menuBizId;

    /**
     * 父菜单ID
     */
    private String parentBizId;

    /**
     * 父菜单ID（用于前端显示绑定参数）
     */
    private String parentId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 类型(1:目录 2:菜单 3:按钮)
     */
    private Integer menuType;

    /**
     * 图标
     */
    private String icon;

    /**
     * 作用域(1:系统级（全局） 2:项目级 3:项目级)
     */
    private Integer scope;

    /**
     * 子级菜单
     */
    private List<ApiRelProjectMenuListPageResponse> children = new ArrayList<>();
}
