package com.yd.user.feign.request.systenant;

import com.yd.common.dto.PageDto;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 租户分页查询-入参
 */
@Data
public class ApiSysTenantPageRequest extends PageDto {

    /**
     * 当前登录用户所属的租户id（当前页面右上角显示的租户）
     */
    private String loginTenantBizId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 开始时间（创建时间）
     */
    private LocalDateTime startTime;

    /**
     * 结束时间（创建时间）
     */
    private LocalDateTime endTime;

}
