package com.yd.user.feign.request.relprojectrole;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 项目和角色关系分页查询入参
 */
@Data
public class ApiRelProjectRoleListPageRequest extends PageDto {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 项目唯一标识(业务ID)
     */
    @NotBlank(message = "项目唯一标识(业务ID)不能为空")
    private String projectBizId;

    /**
     * 角色名称
     */
    private String roleName;
}
