package com.yd.user.feign.fallback.reltenantdept;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reltenantdept.ApiRelTenantDeptFeignClient;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListAddRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListPageRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptTreeListRequest;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeResponse;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptTreeListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 用户服务-租户部门关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantDeptFeignFallbackFactory implements FallbackFactory<ApiRelTenantDeptFeignClient> {
    @Override
    public ApiRelTenantDeptFeignClient create(Throwable cause) {
        return new ApiRelTenantDeptFeignClient() {
            @Override
            public Result page(ApiRelTenantDeptListPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiRelTenantDeptTreeListResponse>> tree(ApiRelTenantDeptTreeListRequest request) {
                return null;
            }

            @Override
            public Result addDeptList(ApiRelTenantDeptListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result<List<ApiRelTenantDeptImportQueryDeptTreeResponse>> importQueryDeptTree(ApiRelTenantDeptImportQueryDeptTreeRequest request) {
                return null;
            }

            @Override
            public Result<List<String>> selectedList(String tenantBizId) {
                return null;
            }
        };
    }
}
