package com.yd.user.feign.fallback.relprojectuser;

import com.yd.common.result.Result;
import com.yd.user.feign.client.relprojectuser.ApiRelProjectUserFeignClient;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListAddRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListPageRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserSelectPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务：项目-用户关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelProjectUserFeignFallbackFactory implements FallbackFactory<ApiRelProjectUserFeignClient> {
    @Override
    public ApiRelProjectUserFeignClient create(Throwable cause) {
        return new ApiRelProjectUserFeignClient() {
            @Override
            public Result page(ApiRelProjectUserListPageRequest request) {
                return null;
            }

            @Override
            public Result addUserList(ApiRelProjectUserListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectUserPage(ApiRelProjectUserSelectPageRequest request) {
                return null;
            }
        };
    }
}
