package com.yd.user.feign.fallback.mdcountry;

import com.yd.common.result.Result;
import com.yd.user.feign.client.mdcountry.ApiMdCountryFeignClient;
import com.yd.user.feign.response.mdcountry.ApiMdCountryGroupResponse;
import com.yd.user.feign.response.mdcountry.ApiMdCountrySearchResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ApiMdCountryFeignFallbackFactory implements FallbackFactory<ApiMdCountryFeignClient> {
    @Override
    public ApiMdCountryFeignClient create(Throwable cause) {
        return new ApiMdCountryFeignClient() {
            @Override
            public Result<ApiMdCountryGroupResponse> group() {
                return null;
            }

            @Override
            public Result<ApiMdCountrySearchResponse> search(String name) {
                return null;
            }

        };
    }
}
