package com.yd.user.feign.client.reltenantdept;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reltenantdept.ApiRelTenantDeptFeignFallbackFactory;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListAddRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptListPageRequest;
import com.yd.user.feign.request.reltenantdept.ApiRelTenantDeptTreeListRequest;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptImportQueryDeptTreeResponse;
import com.yd.user.feign.response.reltenantdept.ApiRelTenantDeptTreeListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务-租户部门关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelTenantDeptFeignFallbackFactory.class)
public interface ApiRelTenantDeptFeignClient {

    /**
     * 租户和部门关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelTenantDeptListPageRequest request);

    /**
     * 租户和部门关系树形列表查询
     * @param request
     * @return
     */
    @PostMapping("/tree")
    Result<List<ApiRelTenantDeptTreeListResponse>> tree(@Validated @RequestBody ApiRelTenantDeptTreeListRequest request);

    /**
     * 添加租户和部门列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/dept/list")
    Result addDeptList(@Validated @RequestBody ApiRelTenantDeptListAddRequest request);

    /**
     * 删除租户和部门关系
     * @param id 租户和部门关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和部门关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-树形部门查询
     * @param request
     * @return
     */
    @PostMapping("/import/query/dept/tree")
    Result<List<ApiRelTenantDeptImportQueryDeptTreeResponse>> importQueryDeptTree(@Validated @RequestBody ApiRelTenantDeptImportQueryDeptTreeRequest request);

    /**
     * 导入-树形部门-查询选中的部门id集合
     * @param tenantBizId
     * @return
     */
    @GetMapping("/import/query/selected/dept/list")
    Result<List<String>> selectedList(@NotBlank(message = "租户id不能为空") @RequestParam(value = "tenantBizId") String tenantBizId);
}
