package com.yd.user.api.controller;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelRoleMenuService;
import com.yd.user.feign.client.relrolemenu.ApiRelRoleMenuFeignClient;
import com.yd.user.feign.request.relrolemenu.ApiProjectRoleMenuListAddRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedProjectRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedTenantRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiTenantRoleMenuListAddRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 角色-菜单关系信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relRoleMenu")
@Validated
public class ApiRelRoleMenuController implements ApiRelRoleMenuFeignClient {

    @Autowired
    private ApiRelRoleMenuService apiRelRoleMenuService;

    /**
     * 租户管理-角色配置-分配菜单-添加菜单角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addTenantRoleMenuList(ApiTenantRoleMenuListAddRequest request) {
        return apiRelRoleMenuService.addTenantRoleMenuList(request);
    }

    /**
     * 租户管理-角色配置-分配菜单-查询选中的菜单列表
     * @return
     */
    @Override
    public Result<List<String>> selectedTenantRoleMenuList(ApiSelectedTenantRoleMenuListRequest request) {
        return apiRelRoleMenuService.selectedTenantRoleMenuList(request);
    }

    /**
     * 项目管理-角色配置-分配菜单-添加菜单角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectRoleMenuList(ApiProjectRoleMenuListAddRequest request) {
        return apiRelRoleMenuService.addProjectRoleMenuList(request);
    }

    /**
     * 项目管理-角色配置-分配菜单-查询选中的菜单列表
     * @return
     */
    @Override
    public Result<List<String>> selectedProjectRoleMenuList(ApiSelectedProjectRoleMenuListRequest request) {
        return apiRelRoleMenuService.selectedProjectRoleMenuList(request);
    }
}
