package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysrole.ApiSysRolePageRequest;
import com.yd.user.feign.response.sysrole.ApiSysRolePageResponse;
import com.yd.user.service.dto.SysRoleDto;
import com.yd.user.service.model.SysRole;
import com.yd.user.service.dao.SysRoleMapper;
import com.yd.user.service.service.ISysRoleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 角色表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class SysRoleServiceImpl extends ServiceImpl<SysRoleMapper, SysRole> implements ISysRoleService {

    /**
     * 角色分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiSysRolePageResponse> page(Page<ApiSysRolePageResponse> page,
                                              ApiSysRolePageRequest request,
                                              Boolean isAdmin,
                                              List<String> projectBizIdList,
                                              String loginTenantBizId) {
        return baseMapper.page(page,request,isAdmin,projectBizIdList,loginTenantBizId);
    }

    /**
     * 查询单个对象
     * @param roleBizId
     * @return
     */
    @Override
    public SysRole queryOne(String roleBizId) {
        return this.getOne(new LambdaQueryWrapper<SysRole>().eq(SysRole::getRoleBizId,roleBizId));
    }

    /**
     * 查询角色列表
     * @param dto
     * @return
     */
    @Override
    public List<SysRole> queryList(SysRoleDto dto) {
        List<SysRole> list = baseMapper.selectList(new LambdaQueryWrapper<SysRole>()
                .eq(!Objects.isNull(dto.getId()),SysRole::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getRoleBizId()) && !dto.getIsExcludeMy(),SysRole::getRoleBizId,dto.getRoleBizId())
                .eq(StringUtils.isNotBlank(dto.getRoleName()),SysRole::getRoleName,dto.getRoleName())
                .in(!CollectionUtils.isEmpty(dto.getRoleBizIdList()),SysRole::getRoleBizId,dto.getRoleBizIdList())
                .ne(dto.getIsExcludeMy(),SysRole::getRoleBizId,dto.getRoleBizId())
        );
        return list;
    }
}
