package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserSelectPageResponse;
import com.yd.user.service.model.RelTenantUser;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 租户-用户关系表（多对多关系） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelTenantUserMapper extends BaseMapper<RelTenantUser> {

    IPage<ApiRelTenantUserListPageResponse> page(@Param("page") IPage<ApiRelTenantUserListPageResponse> page,
                                                 @Param("request") ApiRelTenantUserListPageRequest request);

    IPage<ApiRelTenantUserSelectPageResponse> selectUserPage(@Param("page") IPage<ApiRelTenantUserSelectPageResponse> page,
                                                             @Param("request") ApiRelTenantUserSelectPageRequest request);

}
