package com.yd.user.feign.request.reldeptuser;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiRelTenantDeptUserImportAddRequest {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 部门唯一业务ID
     */
    @NotBlank(message = "部门唯一业务ID不能为空")
    private String deptBizId;

    /**
     * 选中的唯一业务ID列表
     */
    @NotEmpty(message = "选中的唯一业务ID列表不能为空")
    private List<String> userBizIdList;
}
