package com.yd.user.feign.fallback.relrolemenu;

import com.yd.common.result.Result;
import com.yd.user.feign.client.relrolemenu.ApiRelRoleMenuFeignClient;
import com.yd.user.feign.request.relrolemenu.ApiProjectRoleMenuListAddRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedProjectRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedTenantRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiTenantRoleMenuListAddRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户服务：角色-菜单关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelRoleMenuFeignFallbackFactory implements FallbackFactory<ApiRelRoleMenuFeignClient> {
    @Override
    public ApiRelRoleMenuFeignClient create(Throwable cause) {
        return new ApiRelRoleMenuFeignClient() {
            @Override
            public Result addTenantRoleMenuList(ApiTenantRoleMenuListAddRequest request) {
                return null;
            }

            @Override
            public Result<List<String>> selectedTenantRoleMenuList(ApiSelectedTenantRoleMenuListRequest request) {
                return null;
            }

            @Override
            public Result addProjectRoleMenuList(ApiProjectRoleMenuListAddRequest request) {
                return null;
            }

            @Override
            public Result<List<String>> selectedProjectRoleMenuList(ApiSelectedProjectRoleMenuListRequest request) {
                return null;
            }
        };
    }
}
