package com.yd.user.feign.response.login;

import lombok.Data;
import java.util.List;

/**
 * 权限-管理端-获取登录后的项目权限信息
 */
@Data
public class GetLoginPermissionProjectResponse {

    /**
     * 是否是初始密码
     */
    private Boolean isDefaultModifyPwd = false;

    /**
     * 是否是过期密码
     */
    private Boolean isPasswordExpired = false;

    /**
     * 当前登录的用户基础信息
     */
    private ApiLoginUserInfoResponse apiLoginUserInfoResponse;

    /**
     * 当前租户基础信息
     */
    private ApiLoginTenantInfoResponse apiLoginTenantInfoResponse;

    /**
     * 当前项目基础信息
     */
    private ApiLoginProjectInfoResponse apiLoginProjectInfoResponse;

    /**
     * 当前登录用户绑定的当前项目被分配的菜单集合（当前项目用户菜单集合）
     */
    private List<ApiLoginMenuInfoResponse> apiLoginMenuInfoResponseList;

    /**
     * 当前登录用户绑定的当前项目被分配的角色编码集合（当前项目用户角色编码集合）
     */
    private List<String> roles;

    /**
     * 当前登录用户绑定的当前项目被分配的控制页面内的具体操作（按钮级权限）集合（当前项目用户所拥有的所有按钮及权限集合）
     */
    private List<String> permissions;
}
