package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.user.service.dto.ClientUserDto;
import com.yd.user.service.model.ClientUser;
import com.yd.user.service.dao.ClientUserMapper;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.service.IClientUserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 客户端用户表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-20
 */
@Service
public class ClientUserServiceImpl extends ServiceImpl<ClientUserMapper, ClientUser> implements IClientUserService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<ClientUser> queryList(ClientUserDto dto) {
        List<ClientUser> list = baseMapper.selectList(new LambdaQueryWrapper<ClientUser>()
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),ClientUser::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()),ClientUser::getProjectBizId,dto.getProjectBizId())
                .in(!CollectionUtils.isEmpty(dto.getUserBizIdList()),ClientUser::getUserBizId,dto.getUserBizIdList())
        );
        return list;
    }
}
