package com.yd.user.feign.fallback.reldeptuser;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reldeptuser.ApiRelDeptUserFeignClient;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserDelRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportAddRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportPageRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务-部门-用户关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelDeptUserFeignFallbackFactory implements FallbackFactory<ApiRelDeptUserFeignClient> {
    @Override
    public ApiRelDeptUserFeignClient create(Throwable cause) {
        return new ApiRelDeptUserFeignClient() {
            @Override
            public Result page(ApiRelTenantDeptUserPageRequest request) {
                return null;
            }

            @Override
            public Result del(ApiRelTenantDeptUserDelRequest request) {
                return null;
            }

            @Override
            public Result importPage(ApiRelTenantDeptUserImportPageRequest request) {
                return null;
            }

            @Override
            public Result importAdd(ApiRelTenantDeptUserImportAddRequest request) {
                return null;
            }
        };
    }
}
