package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import com.yd.user.service.model.SysMenu;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 菜单权限表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface SysMenuMapper extends BaseMapper<SysMenu> {

    List<ApiSysMenuTreeListResponse> treeList(@Param("loginTenantBizId") String loginTenantBizId,
                                              @Param("isAdmin") Boolean isAdmin,
                                              @Param("menuName") String menuName,
                                              @Param("projectBizIdList") List<String> projectBizIdList);

    IPage<ApiSysMenuPageResponse> page(@Param("page") Page<ApiSysMenuPageResponse> page,
                                       @Param("request") ApiSysMenuPageRequest request,
                                       @Param("isAdmin") Boolean isAdmin,
                                       @Param("projectBizIdList") List<String> projectBizIdList,
                                       @Param("loginTenantBizId") String loginTenantBizId);
}
