package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiMdCountryService;

import com.yd.user.feign.response.mdcountry.ApiMdCountryGroupResponse;
import com.yd.user.feign.response.mdcountry.ApiMdCountrySearchResponse;
import com.yd.user.feign.response.mdcountry.ApiMdCountryVO;
import com.yd.user.service.model.MdCountry;
import com.yd.user.service.service.MdCountryService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiMdCountryServiceImpl implements ApiMdCountryService {

    @Resource
    private MdCountryService mdCountryService;

    @Override
    public Result<ApiMdCountryGroupResponse> group() {
        ApiMdCountryGroupResponse response = new ApiMdCountryGroupResponse();
        // 全部国家
        List<MdCountry> list = mdCountryService.list();
        // model 转 VO
        List<ApiMdCountryVO> groupList = list.stream().map(this::objToVo).collect(Collectors.toList());

        // 热门国家/地区
        List<ApiMdCountryVO> hotList =groupList.stream().filter(item->item.getHotRank()!=9999).collect(Collectors.toList());

        response.setHotCountries(hotList);
        response.setGroupCountries(groupList);

        return Result.success(response);
    }

    @Override
    public Result<ApiMdCountrySearchResponse> search(String name) {
        ApiMdCountrySearchResponse response = new ApiMdCountrySearchResponse();

        QueryWrapper<MdCountry> queryWrapper = new QueryWrapper<>();
        queryWrapper.like("name", name);
        queryWrapper.or();
        queryWrapper.like("country_code", name);
        List<MdCountry> list = mdCountryService.list(queryWrapper);
        // 校验
        if (CollectionUtils.isEmpty(list)) {
            return Result.success(response);
        }
        // model 转 VO
        List<ApiMdCountryVO> groupList = list.stream().map(this::objToVo).collect(Collectors.toList());
        response.setCountryList(groupList);

        return Result.success(response);
    }

    public ApiMdCountryVO objToVo(MdCountry mdCountry) {
        ApiMdCountryVO apiMdCountryVO = new ApiMdCountryVO();
        BeanUtils.copyProperties(mdCountry, apiMdCountryVO);

        return apiMdCountryVO;
    }
}
