package com.yd.user.feign.request.sysproject;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 添加项目-入参
 */
@Data
public class ApiSysProjectAddRequest {

    /**
     * 项目名称
     */
    @NotBlank(message = "项目名称不能为空")
    private String projectName;

    /**
     * 项目描述
     */
    private String description;

    /**
     * 状态(0:禁用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 项目开始时间
     */
    @NotNull(message = "项目开始时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    /**
     * 项目结束时间
     */
    @NotNull(message = "项目结束时间不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    /**
     * 作用域(1:系统级（全局） 2:租户级 )
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 项目图标地址
     */
    @NotBlank(message = "项目图标不能为空")
    private String logoUrl;

    /**
     * 是否内置项目（0-否 1-是 默认0-否 是内置项目，那么整个项目的所绑定的菜单权限都在中台系统展示内嵌外链iframe, 如果不是直接是访问项目卡片直接跳转到独立的前端项目链接获取权限菜单访问）
     */
    @NotNull(message = "是否内置项目不能为空")
    private Integer isIn;

    /**
     * 项目访问地址
     */
    private String projectUrl;
}
