package com.yd.question.service.utils;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

public class MyBatisPlusCodeGenerator {
    public static void main(String[] args) {
        FastAutoGenerator.create("jdbc:mysql://localhost:3306/yd?serverTimezone=GMT%2B8", "root", "123456")
                .globalConfig(builder -> {
                    builder.author("zxm")
//                            .outputDir("src/main/java/com/yd/user/service");
                            .outputDir("D:/soft/ideaproject/v2/yd-question/yd-question-service/src/main/java");
                })
                .packageConfig(builder -> {
                    builder.parent("com.yd.question.service")
                            .entity("model")
                            .mapper("dao")
                            .service("service")
                            .serviceImpl("service.impl")
                            .xml("mappers");
                })
                .strategyConfig(builder -> {
                    builder.addInclude(
                            "rel_object_questionnaire","answer_sessions"
//                            "questionnaires","rel_questionnaire_questions",
//                            "questions_group","rel_questions_group",
//                            "questions","options","add_questions",
//                            "answer_sessions","answers","add_answers"
                    )
                            .entityBuilder()
                            .enableLombok()
                            .enableTableFieldAnnotation()
                            .controllerBuilder()
                            .enableRestStyle();
                })
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}

