package com.yd.question.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 选项附加问题表
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Getter
@Setter
@TableName("add_questions")
public class AddQuestions implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 附加问题唯一业务ID
     */
    @TableField("add_questions_biz_id")
    private String addQuestionsBizId;

    /**
     * 关联问题唯一业务ID
     */
    @TableField("question_biz_id")
    private String questionBizId;

    /**
     * 关联选项唯一业务ID
     */
    @TableField("option_biz_id")
    private String optionBizId;

    /**
     * 附加问题类型(字典：单选/多选/文本/日期/数字)
     */
    @TableField("type")
    private String type;

    /**
     * 附加问题内容
     */
    @TableField("text")
    private String text;

    /**
     * 是否必填 0-否 1-是
     */
    @TableField("is_required")
    private Integer isRequired;

    /**
     * 附加问题排序序号
     */
    @TableField("sort_order")
    private Integer sortOrder;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
