package com.yd.question.feign.dto;

import lombok.Data;
import java.util.List;

/**
 * 问题DTO
 */
@Data
public class ApiQuestionsDto {

    /**
     * 问题表主键id
     */
    private Long id;

    /**
     * 问题唯一业务ID
     */
    private String questionBizId;

    /**
     * 问题内容
     */
    private String text;

    /**
     * 问题类型(字典：单选/多选/文本/日期/数字)
     */
    private String type;

    /**
     * 一级分类（字典：投保人、受保人等）
     */
    private String firstCategory;

    /**
     * 一级分类字典名称（字典：投保人、受保人等）
     */
    private String firstCategoryName;

    /**
     * 二级分类(/病况/通用信息/医保卡使用/女性适用（下次生日年龄为12岁以上）/其他补充说明等)（字典）
     */
    private String secondCategory;

    /**
     * 二级分类字典名称(/病况/通用信息/医保卡使用/女性适用（下次生日年龄为12岁以上）/其他补充说明等)（字典）
     */
    private String secondCategoryName;

    /**
     * 是否必答 0-否 1-是
     */
    private Integer isRequired;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 排序序号
     */
    private Integer sortOrder;

    /**
     * 问题的选项列表信息
     */
    private List<ApiOptionsDto> optionsDtoList;

    /**
     * 答题会话对象（实际回答的内容）
     */
    private ApiAnswerSessionsDto answerSessionsDto;
}
