package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.dto.RelObjectQuestionnaireDto;
import com.yd.question.service.model.RelObjectQuestionnaire;
import com.yd.question.service.dao.RelObjectQuestionnaireMapper;
import com.yd.question.service.service.IRelObjectQuestionnaireService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.SysProject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 对象问卷关联表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Service
public class RelObjectQuestionnaireServiceImpl extends ServiceImpl<RelObjectQuestionnaireMapper, RelObjectQuestionnaire> implements IRelObjectQuestionnaireService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelObjectQuestionnaire> queryList(RelObjectQuestionnaireDto dto) {
        List<RelObjectQuestionnaire> list = baseMapper.selectList(new LambdaQueryWrapper<RelObjectQuestionnaire>()
                .eq(StringUtils.isNotBlank(dto.getObjectBizId()),RelObjectQuestionnaire::getObjectBizId,dto.getObjectBizId())
                .eq(StringUtils.isNotBlank(dto.getQuestionnaireBizId()),RelObjectQuestionnaire::getQuestionnaireBizId,dto.getQuestionnaireBizId())
        );
        return list;
    }
}
