package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.feign.dto.ApiRelQuestionsGroupDto;
import com.yd.question.service.model.Questionnaires;
import com.yd.question.service.dao.QuestionnairesMapper;
import com.yd.question.service.service.IQuestionnairesService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 问卷表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Service
public class QuestionnairesServiceImpl extends ServiceImpl<QuestionnairesMapper, Questionnaires> implements IQuestionnairesService {

    /**
     * 查询单个对象
     * @param questionnaireBizId
     * @return
     */
    @Override
    public Questionnaires queryOne(String questionnaireBizId) {
        return this.getOne(new LambdaQueryWrapper<Questionnaires>()
                .eq(Questionnaires::getQuestionnaireBizId,questionnaireBizId)
        );
    }

    /**
     * 根据问卷业务id查询：问卷问题关联表、分组问题关联表、问题表。三张表关联数据
     * @param questionnaireBizId
     * @return
     */
    @Override
    public List<ApiRelQuestionsGroupDto> relList(String questionnaireBizId){
        return baseMapper.relList(questionnaireBizId);
    }
}
